 ; Ŀ
 ;   Spi - spiral star pattern maker                                       
 ;   Copyright 1993, 1997 by Rocket Software                               
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Cstar - draw an individual grstar (centred).               
 ;   Takes four arguments: centre point, side length, rotation (radians),  
 ;   and colour.  Returns nothing, but draws a star.                       
 ; 
 (DEFUN CSTAR (pa sidlen rota colo / anginc angg hafang pb)
  (setq pa (polar pa (+ rota (/ pi 2)) (* sidlen 1.37638192)))
  (setq anginc (* 1.6 pi))
  (setq angg (+ rota (* 1.6 pi)))
  (setq hafang (* 0.8 pi))
  (repeat 5
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg anginc))
         (setq pa pb)
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg hafang))
         (setq pa pb))
 (princ))
 ; Ŀ
 ;   Subroutine Cstar end.                                                 
 ; 

 ; Ŀ
 ;   Spi.                                                                  
 ; 
 (DEFUN C:SPI (/ pa perc vsize angg rad pa2)
  (setvar "blipmode" 0)
  (setq pa (getpoint "Centre: "))
  (setq vsize (getvar "viewsize"))
  (setq rad (* 0.012 vsize))
  (setq angg 0)
  (while (< rad vsize)
         (setq pa2 (polar pa angg rad))
         (cstar pa2 (* rad 0.1) (- angg (/ pi 2)) 4)
         (setq rad (+ rad (* rad 0.05)))
         (setq angg (+ angg (/ pi 9))))
 (princ))